package com.agilex.healthcare.directscheduling.domain;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name = "clinic", namespace = Namespace.DirectScheduling)
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlType(namespace = Namespace.DirectScheduling)
public class SchedulingClinic extends DomainTransferObject {

    private static final long serialVersionUID = -5171669435333936516L;

    @XmlElement
    private String id;
    @XmlElement
    private String name;
    @XmlElement
    private String department;
    @XmlElement
    private String service;
    @XmlElement
    private String specialty;
    @XmlElement
    private String stopCode;
    @XmlElement
    private SchedulingFacility facility;
    @XmlElement
    private boolean askForCheckIn;
    @XmlElement
    private String facilityCode;
    @XmlElement
    private String friendlyName;
    @XmlElement
    private String dssId;

    @XmlElement
    private String clinicFriendlyName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDepartment() {
        return department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getService() {
        return service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getSpecialty() {
        return specialty;
    }

    public void setSpecialty(String specialty) {
        this.specialty = specialty;
    }

    public String getStopCode() {
        return stopCode;
    }

    public void setStopCode(String stopCode) {
        this.stopCode = stopCode;
    }

    public SchedulingFacility getFacility() {
        return facility;
    }

    public void setFacility(SchedulingFacility facility) {
        this.facility = facility;
    }

    public boolean isAskForCheckIn() {
        return askForCheckIn;
    }

    public void setAskForCheckIn(boolean askForCheckIn) {
        this.askForCheckIn = askForCheckIn;
    }

    public String getFacilityCode() {
        return facilityCode;
    }

    public void setFacilityCode(String facilityCode) {
        this.facilityCode = facilityCode;
    }

    public String getDssId() {
        return dssId;
    }

    public void setDssId(String dssId) {
        this.dssId = dssId;
    }

    public String getFriendlyName() {
        return friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public String getClinicFriendlyName() {
        return clinicFriendlyName;
    }

    public void setClinicFriendlyName(String clinicFriendlyName) {
        this.clinicFriendlyName = clinicFriendlyName;
    }
}
